%% Correlation between input and quantization noise

% This code generates Fig2a


clear all
close all
clc

load('Fig2a_0.mat')
figure
plot(abs(diag(R_s)), 'b-','LineWidth',2);
hold on

load('Fig2a_15.mat')
plot(abs(diag(R_s)), '--','LineWidth',2,'color',[0.8500, 0.3250, 0.0980]);
hold on

load('Fig2a_-15.mat')
plot(abs(diag(R_s)), 'r-.','LineWidth',2);
hold on
plot(abs(diag(R_q)), 'k:','LineWidth',2);
grid on
xlabel('Antenna index')
ylabel('Input-quantization noise correlation')
legend('SD with \psi = 0^0', 'SD with \psi = 15^0','SD with \psi = -15^0','1-bit ADC')
legend('Location','best')
legend boxoff
xlim([0 128])
set(gca,'FontSize',12)

savefig('Fig2a.fig')
saveas(gcf,'Fig2a','epsc')